/*
 * This File is one of the examples from Java Application Development
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */
package chapter3;

import deadlock.*;
import tasks.*;

/**
 *
 * @author Matthew Gregory
 */
public class StartHere {

    
    public static void main(String[] args) {
        //Example (single main thread):
//        System.out.println("About to start task");
//        for (int i=1;i<=100;i++){
//            System.out.println("Number: "+i);
//        }
//        System.out.println("Continuing with main thread.");
        //Two options to run this task in a thread
//        TaskAsThread thread = new TaskAsThread();
//        System.out.println("About to start thread.");
//        thread.start();
//        System.out.println("Continuing with main thread.");
       
        //Option 2: Put the task in a method called run() 
        //in a class that implements runnable.
//        Task myTask = new Task();
//        Thread thread = new Thread(myTask);
//        System.out.println("About to start thread.");
//        thread.start();
//        System.out.println("Continuing with main thread.");
        
        //Sharing the same task between threads.
//        Thread thread1 = new Thread(myTask);
//        Thread thread2 = new Thread(myTask);
//        System.out.println("About to start thread1.");
//        thread1.start();
//        System.out.println("About to start thread2.");
//        thread2.start();
//        System.out.println("Continuing with main thread.");
        
       
        //Naming a thread.
//        Thread thread1 = new Thread(myTask);
//        thread1.setName("Thread 1");
//        Thread thread2 = new Thread(myTask);
//        thread2.setName("Thread 2");
//        thread1.start();
//        thread2.start();

        //Sleeping
        
        //Join
//        System.out.println("All tasks have been completed!");
        //wait for threads to finish before printing out final message
//        System.out.println("Waiting for threads to finish...");
//        try {//Wait for threads to finish
//            thread1.join();
//            System.out.println("Thread 1 finished.");
//            thread2.join();
//            System.out.println("Thread 2 finished.");
//        } catch (InterruptedException ex) {
//            System.out.println("Main thread interrupted.");
//        }
//        System.out.println("All tasks have been completed!");
        
        //Sharing Data
//        SharedTask myTask = new SharedTask();
//        Thread thread1 = new Thread(myTask);
//        thread1.setName("Thread 1");
//        Thread thread2 = new Thread(myTask);
//        thread2.setName("Thread 2");
//        thread1.start();
//        thread2.start();

        //Synchonizing
//        SynchronisedTask myTask = new SynchronisedTask();
//        Thread thread1 = new Thread(myTask);
//        thread1.setName("Thread 1");
//        Thread thread2 = new Thread(myTask);
//        thread2.setName("Thread 2");
//        thread1.start();
//        thread2.start();

        //Locks
        SharedResource1 r1 = new SharedResource1();
        SharedResource2 r2 = new SharedResource2();
        Thread firstThread = new Thread(new Task1(r1,r2));
        firstThread.setName("Thread 1");
        firstThread.start();

        //Starting a second thread that is competing for the same resources.
        Thread secondThread = new Thread(new Task1(r1,r2));
        secondThread.setName("Thread 2");
        secondThread.start();
        
        //Deadlock
//        SharedResource1 r1 = new SharedResource1();
//        SharedResource2 r2 = new SharedResource2();
//        Thread firstThread = new Thread(new Task1(r1,r2));
//        firstThread.setName("Thread 1");
//        Thread secondThread = new Thread(new Task2(r1,r2));
//        secondThread.setName("Thread 2");
//        firstThread.start();
//        secondThread.start();
        
    }
    
}
